const config = require('../config')
const pre = config.database.pre
const QueryBuilder = require('node-querybuilder');
const pool = new QueryBuilder(config.settings, 'mysql', 'pool');

  async function get_country_name(id) {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('*').where('ID', id).get(pre+'_country');
        //console.log("Query Ran: " + qb.last_query());
        qb.release();
        return response[0].COUNTRY_NAME;
    } catch (err) {
        //console.error(err)
        return "Fail";
    }
  }


module.exports = {
    get_country_name
}

/* 

INSTRUCTIONS
===================

1. Query Builder Reference : https://www.npmjs.com/package/node-querybuilder#how-to-install

*/