const config = require('../config')
const pre = config.database.pre
const QueryBuilder = require('node-querybuilder');
const pool = new QueryBuilder(config.settings, 'mysql', 'pool');

  async function get_company() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('*').get(pre+'_company_master');
        //console.log("Query Ran: " + qb.last_query());
        qb.release();
        return response[0];
    } catch (err) {
        //console.error(err)
        return "Fail";
    }
  }

  async function get_company_logos() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('company_logo,company_white_logo').get(pre+'_company_master');
        //console.log("Query Ran: " + qb.last_query());
        qb.release();
        return response[0];
    } catch (err) {
        //console.error(err)
        return "Fail";
    }
  }


module.exports = {
    get_company,get_company_logos
}

/* 

INSTRUCTIONS
===================

1. Query Builder Reference : https://www.npmjs.com/package/node-querybuilder#how-to-install

*/