const config = require('../config')
const pre = config.database.pre
const QueryBuilder = require('node-querybuilder');
const pool = new QueryBuilder(config.settings, 'mysql', 'pool');

  async function get_social_links() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('*').get(pre+'_social_link');
        //console.log("Query Ran: " + qb.last_query());
        qb.release();
        return response[0];
    } catch (err) {
        //console.error(err)
        return "Fail";
    }
  }

  async function get_store_app_link() {
    try {
        let qb = await pool.get_connection();
        let response = await qb.select('playstoreimage,applestoreimage,playstore_link,applestore_link').get(pre+'_homepage_section7');
        //console.log("Query Ran: " + qb.last_query());
        qb.release();
        return response[0];
    } catch (err) {
        //console.error(err)
        return "Fail";
    }
  }


module.exports = {
    get_social_links,get_store_app_link
}

/* 

INSTRUCTIONS
===================

1. Query Builder Reference : https://www.npmjs.com/package/node-querybuilder#how-to-install

*/